/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.AddConnectConnectionInfo;
import com.ibm.hwmca.fw.connmgr.Authenticator;
import com.ibm.hwmca.fw.connmgr.ClientConnection;
import com.ibm.hwmca.fw.connmgr.CloseGroupConnectionInfo;
import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.connmgr.ConnectionInfo;
import com.ibm.hwmca.fw.connmgr.ConnectionManager;
import com.ibm.hwmca.fw.connmgr.ConnectionReply;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.DisabledUseridException;
import com.ibm.hwmca.fw.connmgr.GroupClosedException;
import com.ibm.hwmca.fw.connmgr.HMCAuthenticator;
import com.ibm.hwmca.fw.connmgr.HMCLocalAuthenticator;
import com.ibm.hwmca.fw.connmgr.HMCSocketFactory;
import com.ibm.hwmca.fw.connmgr.InitialConnectionInfo;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.connmgr.MultiConnectConnectionInfo;
import com.ibm.hwmca.fw.connmgr.MultiConnectionReply;
import com.ibm.hwmca.fw.connmgr.SingleConnectConnectionInfo;
import com.ibm.hwmca.fw.connmgr.VerifyConnectionInfo;
import com.ibm.hwmca.fw.connmgr.VerifyConnectionReply;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;

public class ConnectionFactory
implements ConnectionConstants {
    private static HashMap CLIENT_IDS = new HashMap();
    private static ConnectionFactory USER_CONNECTION_FACTORY;
    public static final String THIS_CLASS = "ConnectionFactory";
    private InetAddress _host;
    private int _port;
    private ContextId _clientID = null;
    private String _userName = "logonuser";
    private byte[] _password = ConnectionConstants.LOGON_PASSWORD;

    public static ConnectionFactory getUserConnectionFactory() throws UnknownHostException {
        ConnectionFactory factory = null;
        try {
            factory = ClientUserContext.getUserContext().getConnectionFactory();
        }
        catch (NullContextException e) {
            CommonSystem sys = CommonSystem.getCommonSystem();
            if (sys.isUsingHTML()) {
                RuntimeException ex = new RuntimeException("There is no user context from which to get the connection factory.", e);
                ConnectionManager.logException(ex, (short)2096);
                throw ex;
            }
            if (USER_CONNECTION_FACTORY == null) {
                InetAddress host = sys.getManagerHost();
                USER_CONNECTION_FACTORY = new ConnectionFactory(host, 9940);
            }
            factory = USER_CONNECTION_FACTORY;
        }
        return factory;
    }

    public ConnectionFactory(InetAddress host, int port) {
        this._host = host;
        this._port = port;
    }

    public InetAddress getServerAddress() {
        return this._host;
    }

    public int getServerPort() {
        return this._port;
    }

    public String getUserName() {
        return this._userName;
    }

    byte[] getPassword() {
        return this._password;
    }

    private boolean isLogonUser() {
        return this.getUserName().equals("logonuser");
    }

    public boolean isAuthenticating() {
        return !this.getUserName().equals("logonuser") || !this.getPassword().equals(ConnectionConstants.LOGON_PASSWORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateUserContext(ClientUserContext clientContext) throws SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, IOException, InvalidPasswordException, NullContextException, HException {
        Trace.trace("HSSLCONF", "--> ConnectionFactory.updateUserContext:  sending initial connection info with context " + clientContext);
        Connector c = new Connector();
        c.connect(new InitialConnectionInfo(clientContext));
        this._clientID = c._uid;
        HashMap hashMap = CLIENT_IDS;
        synchronized (hashMap) {
            CLIENT_IDS.put(this.getClientIdsKey(), this._clientID);
        }
        c.close();
        Trace.trace("HSSLCONF", "<-- ConnectionFactory.updateUserContext:  ");
    }

    public ContextId getClientID() {
        Trace.trace("HSSLCONF", "--> ConnectionFactory.getClientID:  ");
        if (this.isLogonUser()) {
            Trace.trace("HSSLCONF", "<-- ConnectionFactory.getClientID:  for logonuser, returning null");
            return null;
        }
        if (this._clientID == null) {
            Trace.trace("HSSLCONF", "ConnectionFactory.getClientID:  is null");
            this._clientID = (ContextId)CLIENT_IDS.get(this.getClientIdsKey());
            Trace.trace("HSSLCONF", "ConnectionFactory.getClientID:  clearedn CLIENT_IDS");
        }
        Trace.trace("HSSLCONF", "<-- ConnectionFactory.getClientID:  for " + this.getUserName() + " returning " + this._clientID);
        return this._clientID;
    }

    private String getClientIdsKey() {
        String id = this.getServerAddress().getHostName() + this.getServerPort() + this.getUserName();
        Trace.trace("HSSLCONF", "ConnectionFactory.getClientIdsKey:  returning " + id);
        return id;
    }

    private void clearClientId() {
        Trace.trace("HSSLCONF", "--> ConnectionFactory.clearClientId:  ");
        this._clientID = null;
        CLIENT_IDS.remove(this.getClientIdsKey());
        Trace.trace("HSSLCONF", "<-- ConnectionFactory.clearClientId:  ");
    }

    public synchronized void resetUserAndPassword() throws UnknownHostException, ClassNotFoundException {
        Trace.trace("HSSLCONT", "-> ConnectionFactory.java.resetUserAndPassword()");
        this.clearClientId();
        this._userName = "logonuser";
        this._password = ConnectionConstants.LOGON_PASSWORD;
        Trace.trace("HSSLCONT", "<- ConnectionFactory.java.resetUserAndPassword()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setUserAndPassword(String userName, byte[] password) throws SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, IOException, DisabledUseridException, InvalidPasswordException, Exception {
        Trace.trace("HSSLCONT", "-> ConnectionFactory.java.setUserAndPassword(" + userName + ")");
        if (userName.equals(this.getUserName()) && Arrays.equals(password, this.getPassword())) {
            return;
        }
        if (userName.trim().equals("") || password.length == 0) {
            throw new InvalidPasswordException(userName);
        }
        this._userName = userName;
        this._password = password;
        this.clearClientId();
        if (!userName.equals("logonuser")) {
            try {
                this._clientID = null;
                Connector c = new Connector();
                ContextId cid = this.getClientID();
                Trace.trace("HSSLCONF", "ConnectionFactory.setUserAndPassword:  cid = " + cid);
                c.connect(new VerifyConnectionInfo(cid));
                c.close();
                VerifyConnectionReply reply = (VerifyConnectionReply)c._reply;
                if (reply._status == 1) {
                    throw new DisabledUseridException(null);
                }
                Trace.trace("HSSLCONF", "ConnectionFactory.setUserAndPassword:  setting _clientId");
                this._clientID = c._uid;
                HashMap hashMap = CLIENT_IDS;
                synchronized (hashMap) {
                    CLIENT_IDS.put(this.getClientIdsKey(), this._clientID);
                }
            }
            catch (Exception e) {
                Trace.trace("HSSLCONF", "ConnectionFactory.java, setUserAndPassword for user " + userName, e);
                throw e;
            }
        }
        Trace.trace("HSSLCONT", "<- ConnectionFactory.java.setUserAndPassword(" + userName + ")");
    }

    public synchronized void closeGroup(ConnectionGroup cg) throws SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, IOException, GroupClosedException, InvalidPasswordException, NullContextException, HException {
        Trace.trace("HSSLCONT", "-> ConnectionFactory.java.closeGroup(" + cg + ")");
        if (cg._isClosed) {
            throw new GroupClosedException(cg);
        }
        Connector c = new Connector();
        c.connect(new CloseGroupConnectionInfo(cg.getID(), this.getClientID()));
        c.close();
        Trace.trace("HSSLCONT", "<- ConnectionFactory.java.closeGroup()");
    }

    public synchronized Connection getNewConnection(ConnectionGroup cg, Serializable parm) throws SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, IOException, GroupClosedException, InvalidPasswordException, NullContextException, HException {
        Trace.trace("HSSLCONT", "-> ConnectionFactory.java.getNewConnection(" + cg + ", " + parm + ")");
        if (cg._isClosed) {
            throw new GroupClosedException(cg);
        }
        Connector c = new Connector();
        c.connect(new AddConnectConnectionInfo(parm, cg.getID(), this.getClientID()));
        ClientConnection sock = new ClientConnection(c._socket, this.isAuthenticating());
        Trace.trace("HSSLCONT", "<- ConnectionFactory.java.getNewConnection( returning " + sock + " )");
        return sock;
    }

    public synchronized ConnectionGroup getConnections(String handlerName, int connectionCount, Serializable parm) throws SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, IOException, InvalidPasswordException, Exception {
        Trace.trace("HSSLCONT", "-> ConnectionFactory.java.getConnections(" + handlerName + ", " + connectionCount + ", " + parm + ")");
        UUID id = null;
        Connector c = new Connector();
        AddConnectConnectionInfo info = null;
        info = connectionCount == 1 ? new SingleConnectConnectionInfo(handlerName, parm, this.getClientID()) : new MultiConnectConnectionInfo(handlerName, parm, 0, connectionCount, null, this.getClientID());
        c.connect(info);
        id = ((MultiConnectionReply)c._reply)._groupId;
        ConnectionGroup group = new ConnectionGroup(id, connectionCount);
        group.add(new ClientConnection(c._socket, this.isAuthenticating()));
        try {
            for (int i = 1; i < connectionCount; ++i) {
                info = new MultiConnectConnectionInfo("", null, i, connectionCount, id, this.getClientID());
                c.connect(info);
                group.add(new ClientConnection(c._socket, this.isAuthenticating()));
            }
        }
        catch (Exception e) {
            group.closeConnections();
            throw e;
        }
        Trace.trace("HSSLCONT", "<- ConnectionFactory.java.getConnections( returning " + group + ")");
        return group;
    }

    public String toString() {
        return "ConnectionFactory( host=" + this._host + ", port=" + this._port + " )";
    }

    class Connector {
        public static final String THIS_CLASS = "ConnectionFactory.Connector";
        ContextId _uid;
        Socket _socket;
        ConnectionReply _reply;

        Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connect(ConnectionInfo info) throws SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, IOException, InvalidPasswordException, HException {
            Trace.trace("HSSLCONT", "ConnectionFactory.java.connect:  for user " + ConnectionFactory.this.getUserName());
            Object ex = null;
            try {
                HMCSocketFactory factory = HMCSocketFactory.getFactory();
                this._socket = ((SocketFactory)factory).createSocket(ConnectionFactory.this._host, ConnectionFactory.this._port);
                if (this._socket == null) {
                    IOException ioe = new IOException("Unable to create an SSLSocket to " + ConnectionFactory.this._host + " at port " + ConnectionFactory.this._port + ".  SSLSocket constructor returned null.");
                    Trace.trace("HSSLCONF", "ConnectionFactory.Connector.connect:  ", ioe);
                    ConnectionManager.logException(ioe);
                    throw ioe;
                }
                Trace.trace("HSSLCONF", "ConnectionFactory.java.connect:  socket factory created " + this._socket);
                this._socket.setSoTimeout(30000);
                Authenticator authenticator = null;
                if (HMCSocketFactory.localConnection(ConnectionFactory.this._port)) {
                    Trace.trace("HSSLCONF", "ConnectionFactory.java.connect:  using local authenticator");
                    authenticator = new HMCLocalAuthenticator(this._socket);
                } else {
                    Trace.trace("HSSLCONF", "ConnectionFactory.java.connect:  using ssl authenticator");
                    authenticator = new HMCAuthenticator(this._socket);
                }
                boolean connected = false;
                if (ConnectionFactory.this._clientID != null && !ConnectionFactory.this.isLogonUser()) {
                    Trace.trace("HSSLCOND", "ConnectionFactory.Connector.connect:  Found an existing context.  Submitting context id and password credentials.");
                    Trace.trace("HSSLCONF", "ConnectionFactory.Connector.connect:  client id bytes are " + ConnectionFactory.this._clientID);
                    try {
                        connected = authenticator.verifyContext(ConnectionFactory.this._clientID);
                    }
                    catch (Exception e) {
                        connected = false;
                    }
                    if (!connected) {
                        this._socket = ((SocketFactory)factory).createSocket(ConnectionFactory.this._host, ConnectionFactory.this._port);
                        this._socket.setSoTimeout(30000);
                        authenticator = HMCSocketFactory.localConnection(ConnectionFactory.this._port) ? new HMCLocalAuthenticator(this._socket) : new HMCAuthenticator(this._socket);
                    }
                }
                if (!connected) {
                    Trace.trace("HSSLCOND", "ConnectionFactory.Connector.connect:  No existing context.  Submitting userid and password for credentials.");
                    if (!authenticator.verifyUseridAndPassword(ConnectionFactory.this.getUserName(), ConnectionFactory.this.getPassword())) {
                        String userName = ConnectionFactory.this.getUserName();
                        throw new InvalidPasswordException("User name " + userName + " is invalid with the supplied password.");
                    }
                }
                ObjectOutputStream oos = new ObjectOutputStream(this._socket.getOutputStream());
                ObjectInputStream ois = new ObjectInputStream(this._socket.getInputStream());
                oos.reset();
                oos.writeObject(info);
                oos.flush();
                this._reply = (ConnectionReply)ois.readObject();
                this._uid = this._reply._id;
                this._socket.setSoTimeout(0);
                Trace.trace("HSSLCOND", "ConnectionFactory.Connector.connect:  reply is " + this._reply);
            }
            finally {
                if (ex != null) {
                    this.close();
                }
            }
        }

        void close() {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (Exception e) {
                    Trace.trace("HSSLCONF", "ConnectionFactory.java.close:  failed to close socket " + this._socket);
                }
            }
        }
    }
}

